import { Scissors, Mail, Phone, MapPin, Clock, Instagram, Facebook, Heart } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-sewing">
      <div className="container">
        <div className="footer-content-sewing">
          <div className="footer-section-sewing">
            <div className="footer-logo-sewing">
              <div className="footer-logo-icon-wrapper-sewing">
                <Scissors className="footer-logo-icon-sewing" size={28} />
              </div>
              <h2 className="footer-logo-text-sewing">STITCHCRAFT</h2>
            </div>
            <p className="footer-description-sewing">
              Элегантные курсы по шитью от мастеров своего дела. 
              Научитесь создавать красивые вещи своими руками.
            </p>
            <div className="footer-social-sewing">
              <a href="#" className="social-link-sewing">
                <Instagram size={20} />
              </a>
              <a href="#" className="social-link-sewing">
                <Facebook size={20} />
              </a>
              <a href="#" className="social-link-sewing">
                <Heart size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section-sewing">
            <h3 className="footer-title-sewing">Навигация</h3>
            <ul className="footer-links-sewing">
              <li><a href="/">Мои курсы</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Галерея</a></li>
            </ul>
          </div>
          <div className="footer-section-sewing">
            <h3 className="footer-title-sewing">Контакты</h3>
            <ul className="footer-links-sewing">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@stitchcraft.ru">info@stitchcraft.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Ткацкая, 15</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Сб: 10:00 - 20:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-sewing">
          <p>&copy; 2025 STITCHCRAFT. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

